/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.entity;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.block.branch.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.entity.animation.AnimationHandler;
import com.ferreusveritas.dynamictrees.entity.animation.AnimationHandlers;
import com.ferreusveritas.dynamictrees.entity.animation.DataAnimationHandler;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.models.FallingTreeEntityModelTrackerCache;
import com.ferreusveritas.dynamictrees.models.ModelTracker;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class FallingTreeEntity
extends Entity
implements ModelTracker {
    public static final EntityDataAccessor<CompoundTag> voxelDataParameter = SynchedEntityData.m_135353_(FallingTreeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    protected List<ItemStack> payload = new ArrayList<ItemStack>(0);
    protected float volume = 0.0f;
    protected boolean hasLeaves = false;
    protected BranchDestructionData destroyData = new BranchDestructionData();
    protected Vec3 geomCenter = Vec3.f_82478_;
    protected Vec3 massCenter = Vec3.f_82478_;
    protected AABB normalBB = new AABB(BlockPos.f_121853_);
    protected AABB cullingNormalBB = new AABB(BlockPos.f_121853_);
    protected boolean clientBuilt = false;
    protected boolean firstUpdate = true;
    public boolean landed = false;
    public DestroyType destroyType = DestroyType.HARVEST;
    public boolean onFire = false;
    protected AABB cullingBB;
    protected Species species;
    public static AnimationHandler AnimHandlerFall = AnimationHandlers.falloverAnimationHandler;
    public static AnimationHandler AnimHandlerDrop = AnimationHandlers.defaultAnimationHandler;
    public static AnimationHandler AnimHandlerBurn = AnimationHandlers.defaultAnimationHandler;
    public static AnimationHandler AnimHandlerFling = AnimationHandlers.defaultAnimationHandler;
    public static AnimationHandler AnimHandlerBlast = AnimationHandlers.blastAnimationHandler;
    public AnimationHandler currentAnimationHandler = AnimationHandlers.voidAnimationHandler;
    public DataAnimationHandler dataAnimationHandler = null;

    public FallingTreeEntity(Level level) {
        super(DTRegistries.FALLING_TREE.get(), level);
    }

    public FallingTreeEntity(EntityType<? extends FallingTreeEntity> type, Level level) {
        super(type, level);
    }

    public boolean isClientBuilt() {
        return this.clientBuilt;
    }

    public FallingTreeEntity setData(BranchDestructionData destroyData, List<ItemStack> payload, DestroyType destroyType) {
        this.destroyData = destroyData;
        if (destroyData.getNumBranches() == 0) {
            System.err.println("Warning: Tried to create a EntityFallingTree with no branch blocks. This shouldn't be possible.");
            new Exception().printStackTrace();
            this.m_6074_();
            return this;
        }
        BlockPos basePos = destroyData.basePos;
        this.payload = payload;
        this.destroyType = destroyType;
        this.onFire = destroyType == DestroyType.FIRE;
        this.volume = destroyData.woodVolume.getVolume();
        this.hasLeaves = destroyData.getNumLeaves() > 0;
        this.species = destroyData.species;
        this.m_20343_((double)basePos.m_123341_() + 0.5, basePos.m_123342_(), (double)basePos.m_123343_() + 0.5);
        int numBlocks = destroyData.getNumBranches();
        this.geomCenter = new Vec3(0.0, 0.0, 0.0);
        double totalMass = 0.0;
        for (int index = 0; index < destroyData.getNumBranches(); ++index) {
            BlockPos relPos = destroyData.getBranchRelPos(index);
            int radius = destroyData.getBranchRadius(index);
            float mass = (float)(radius * radius * 64) / 4096.0f;
            totalMass += (double)mass;
            Vec3 relVec = new Vec3((double)relPos.m_123341_(), (double)relPos.m_123342_(), (double)relPos.m_123343_());
            this.geomCenter = this.geomCenter.m_82549_(relVec);
            this.massCenter = this.massCenter.m_82549_(relVec.m_82490_((double)mass));
        }
        this.geomCenter = this.geomCenter.m_82490_(1.0 / (double)numBlocks);
        this.massCenter = this.massCenter.m_82490_(1.0 / totalMass);
        this.setVoxelData(this.buildVoxelData(destroyData));
        return this;
    }

    public CompoundTag buildVoxelData(BranchDestructionData destroyData) {
        CompoundTag tag = new CompoundTag();
        destroyData.writeToNBT(tag);
        tag.m_128347_("geomx", this.geomCenter.f_82479_);
        tag.m_128347_("geomy", this.geomCenter.f_82480_);
        tag.m_128347_("geomz", this.geomCenter.f_82481_);
        tag.m_128347_("massx", this.massCenter.f_82479_);
        tag.m_128347_("massy", this.massCenter.f_82480_);
        tag.m_128347_("massz", this.massCenter.f_82481_);
        tag.m_128405_("destroytype", this.destroyType.ordinal());
        tag.m_128379_("onfire", this.onFire);
        tag.m_128350_("volume", this.volume);
        tag.m_128379_("hasleaves", this.hasLeaves);
        tag.m_128359_("species", this.species.getRegistryName().toString());
        return tag;
    }

    public void setupFromNBT(CompoundTag tag) {
        this.destroyData = new BranchDestructionData(tag);
        if (this.destroyData.getNumBranches() == 0) {
            this.m_6074_();
        }
        this.destroyType = DestroyType.values()[tag.m_128451_("destroytype")];
        this.geomCenter = new Vec3(tag.m_128459_("geomx"), tag.m_128459_("geomy"), tag.m_128459_("geomz"));
        this.massCenter = new Vec3(tag.m_128459_("massx"), tag.m_128459_("massy"), tag.m_128459_("massz"));
        this.m_20011_(this.buildAABBFromDestroyData(this.destroyData).m_82386_(this.m_20185_(), this.m_20186_(), this.m_20189_()));
        this.cullingBB = this.cullingNormalBB.m_82386_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.volume = tag.m_128457_("volume");
        this.hasLeaves = tag.m_128471_("hasleaves");
        this.species = (Species)Species.REGISTRY.get(tag.m_128461_("species"));
        this.onFire = tag.m_128471_("onfire");
    }

    public void buildClient() {
        CompoundTag tag = this.getVoxelData();
        if (tag.m_128441_("species")) {
            this.setupFromNBT(tag);
            this.clientBuilt = true;
        } else {
            System.out.println("Error: No species tag has been set");
        }
        BlockBounds renderBounds = new BlockBounds(this.destroyData.cutPos);
        this.cleanupShellBlocks(this.destroyData);
        Minecraft.m_91087_().f_91060_.m_109494_(renderBounds.getMin().m_123341_(), renderBounds.getMin().m_123342_(), renderBounds.getMin().m_123343_(), renderBounds.getMax().m_123341_(), renderBounds.getMax().m_123342_(), renderBounds.getMax().m_123343_());
    }

    protected void cleanupShellBlocks(BranchDestructionData destroyData) {
        BlockPos cutPos = destroyData.cutPos;
        for (int i = 0; i < destroyData.getNumBranches(); ++i) {
            if (destroyData.getBranchRadius(i) <= 8) continue;
            BlockPos pos = destroyData.getBranchRelPos(i).m_121955_((Vec3i)cutPos);
            for (CoordUtils.Surround dir : CoordUtils.Surround.values()) {
                BlockPos dPos = pos.m_121955_(dir.getOffset());
                if (!(this.m_9236_().m_8055_(dPos).m_60734_() instanceof TrunkShellBlock)) continue;
                this.m_9236_().m_7471_(dPos, false);
            }
        }
    }

    public AABB buildAABBFromDestroyData(BranchDestructionData destroyData) {
        this.normalBB = new AABB(BlockPos.f_121853_);
        for (BlockPos relPos : destroyData.getPositions(BranchDestructionData.PosType.BRANCHES, false)) {
            this.normalBB = this.normalBB.m_82367_(new AABB(relPos));
        }
        if (destroyData.species.leavesAreSolid()) {
            for (BlockPos relPos : destroyData.getPositions(BranchDestructionData.PosType.LEAVES, false)) {
                this.normalBB = this.normalBB.m_82367_(new AABB(relPos));
            }
        }
        double height = this.normalBB.f_82292_ - this.normalBB.f_82289_;
        double width = Mth.m_14005_((double)(this.normalBB.f_82291_ - this.normalBB.f_82288_), (double)(this.normalBB.f_82293_ - this.normalBB.f_82290_));
        double grow = Math.max(0.0, height - width / 2.0) + 2.0;
        this.cullingNormalBB = this.normalBB.m_82377_(grow + 4.0, 4.0, grow + 4.0);
        return this.normalBB;
    }

    public AABB m_6921_() {
        return this.cullingBB;
    }

    public BranchDestructionData getDestroyData() {
        return this.destroyData;
    }

    public List<ItemStack> getPayload() {
        return this.payload;
    }

    public Vec3 getGeomCenter() {
        return this.geomCenter;
    }

    public Vec3 getMassCenter() {
        return this.massCenter;
    }

    public float getVolume() {
        return this.volume;
    }

    public boolean hasLeaves() {
        return this.hasLeaves;
    }

    public Species getSpecies() {
        return this.species;
    }

    public void m_6034_(double x, double y, double z) {
        this.m_20343_(x, y, z);
        this.m_20011_(this.normalBB != null ? this.normalBB.m_82386_(x, y, z) : new AABB(BlockPos.f_121853_));
        this.cullingBB = this.cullingNormalBB != null ? this.cullingNormalBB.m_82386_(x, y, z) : new AABB(BlockPos.f_121853_);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_ && !this.clientBuilt) {
            this.buildClient();
            if (!this.m_6084_()) {
                return;
            }
        }
        if (!this.m_9236_().f_46443_ && this.firstUpdate) {
            this.updateNeighbors();
        }
        this.handleMotion();
        this.m_20011_(this.normalBB.m_82386_(this.m_20185_(), this.m_20186_(), this.m_20189_()));
        this.cullingBB = this.cullingNormalBB.m_82386_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        if (this.shouldDie()) {
            this.dropPayLoad();
            this.m_6074_();
            this.modelCleanup();
        }
        this.firstUpdate = false;
    }

    protected void updateNeighbors() {
        HashSet destroyed = new HashSet();
        HashSet<BlockPos> toUpdate = new HashSet<BlockPos>();
        Iterables.concat(this.destroyData.getPositions(BranchDestructionData.PosType.BRANCHES), this.destroyData.getPositions(BranchDestructionData.PosType.LEAVES)).forEach(destroyed::add);
        for (BlockPos d : destroyed) {
            for (Direction dir : Direction.values()) {
                BlockPos dPos = d.m_121945_(dir);
                if (destroyed.contains(dPos)) continue;
                toUpdate.add(dPos);
            }
        }
        toUpdate.forEach(pos -> this.m_9236_().m_46586_(pos, Blocks.f_50016_, pos));
    }

    protected AnimationHandler selectAnimationHandler() {
        return (Boolean)DTConfigs.ENABLE_FALLING_TREES.get() != false ? this.destroyData.species.selectAnimationHandler(this) : AnimationHandlers.voidAnimationHandler;
    }

    public AnimationHandler defaultAnimationHandler() {
        if (this.destroyType == DestroyType.VOID || this.destroyType == DestroyType.ROOT) {
            return AnimationHandlers.voidAnimationHandler;
        }
        if (this.destroyType == DestroyType.BLAST) {
            return AnimHandlerBlast;
        }
        if (this.destroyType == DestroyType.FIRE) {
            return AnimHandlerBurn;
        }
        if (this.getDestroyData().cutDir == Direction.DOWN) {
            if (this.getMassCenter().f_82480_ >= 1.0) {
                return AnimHandlerFall;
            }
            return AnimHandlerFling;
        }
        return AnimHandlerDrop;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void modelCleanup() {
        FallingTreeEntityModelTrackerCache.cleanupModels(this.m_9236_(), this);
    }

    public void handleMotion() {
        if (this.firstUpdate) {
            this.currentAnimationHandler = this.selectAnimationHandler();
            this.currentAnimationHandler.initMotion(this);
        } else {
            this.currentAnimationHandler.handleMotion(this);
        }
    }

    public void dropPayLoad() {
        if (!this.m_9236_().f_46443_) {
            this.currentAnimationHandler.dropPayload(this);
        }
    }

    public boolean shouldDie() {
        return this.f_19797_ > 20 && this.currentAnimationHandler.shouldDie(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRender() {
        return this.currentAnimationHandler.shouldRender(this);
    }

    public static void standardDropLogsPayload(FallingTreeEntity entity) {
        Level level = entity.m_9236_();
        if (!level.f_46443_) {
            BlockPos cutPos = entity.getDestroyData().cutPos;
            entity.getPayload().forEach(i -> FallingTreeEntity.spawnItemAsEntity(level, cutPos, i));
        }
    }

    public static void standardDropLeavesPayLoad(FallingTreeEntity entity) {
        Level level = entity.m_9236_();
        if (!level.f_46443_) {
            BlockPos cutPos = entity.getDestroyData().cutPos;
            entity.getDestroyData().leavesDrops.forEach(bis -> Block.m_49840_((Level)level, (BlockPos)cutPos.m_121955_((Vec3i)bis.pos), (ItemStack)bis.stack));
        }
    }

    public static void spawnItemAsEntity(Level level, BlockPos pos, ItemStack stack) {
        if (!level.f_46443_ && !stack.m_41619_() && level.m_46469_().m_46207_(GameRules.f_46136_) && !level.restoringBlockSnapshots) {
            ItemEntity entityitem = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
            entityitem.m_20334_(0.0, 0.0, 0.0);
            entityitem.m_32060_();
            level.m_7967_((Entity)entityitem);
        }
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(voxelDataParameter, (Object)new CompoundTag());
    }

    public void cleanupRootyDirt() {
        if (!this.m_9236_().f_46443_) {
            BlockPos rootPos = this.getDestroyData().cutPos.m_7495_();
            BlockState belowState = this.m_9236_().m_8055_(rootPos);
            if (TreeHelper.isRooty(belowState)) {
                RootyBlock rootyBlock = (RootyBlock)belowState.m_60734_();
                rootyBlock.doDecay(this.m_9236_(), rootPos, belowState, this.getDestroyData().species);
            }
        }
    }

    public void setVoxelData(CompoundTag tag) {
        this.m_20011_(this.buildAABBFromDestroyData(this.destroyData).m_82386_(this.m_20185_(), this.m_20186_(), this.m_20189_()));
        this.cullingBB = this.cullingNormalBB.m_82386_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20088_().m_135381_(voxelDataParameter, (Object)tag);
    }

    public CompoundTag getVoxelData() {
        return (CompoundTag)this.m_20088_().m_135370_(voxelDataParameter);
    }

    protected void m_7378_(CompoundTag compound) {
        CompoundTag vox = (CompoundTag)compound.m_128423_("vox");
        this.setupFromNBT(vox);
        this.setVoxelData(vox);
        if (compound.m_128441_("payload")) {
            ListTag nbtList = (ListTag)compound.m_128423_("payload");
            for (Tag tag : Objects.requireNonNull(nbtList)) {
                if (!(tag instanceof CompoundTag)) continue;
                CompoundTag compTag = (CompoundTag)tag;
                this.payload.add(ItemStack.m_41712_((CompoundTag)compTag));
            }
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128365_("vox", (Tag)this.getVoxelData());
        if (!this.payload.isEmpty()) {
            ListTag list = new ListTag();
            for (ItemStack stack : this.payload) {
                list.add((Object)stack.serializeNBT());
            }
            compound.m_128365_("payload", (Tag)list);
        }
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static FallingTreeEntity dropTree(Level level, BranchDestructionData destroyData, List<ItemStack> woodDropList, DestroyType destroyType) {
        if (!level.f_46443_) {
            FallingTreeEntity entity = new FallingTreeEntity(level).setData(destroyData, woodDropList, destroyType);
            if (entity.m_6084_()) {
                level.m_7967_((Entity)entity);
            }
            return entity;
        }
        return null;
    }

    public static enum DestroyType {
        VOID,
        HARVEST,
        BLAST,
        FIRE,
        ROOT;

    }
}

